/*
 * Decompiled with CFR 0.152.
 */
package ki.aletheia;

import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import ki.aletheia.Abloesen;
import ki.aletheia.Aletheia;
import ki.aletheia.Aneignen;
import ki.aletheia.Bewerter;
import ki.aletheia.Brett;
import ki.aletheia.Drehen;
import ki.aletheia.Enteignen;
import ki.aletheia.Entfernen;
import ki.aletheia.Ersetzen;
import ki.aletheia.Feld;
import ki.aletheia.Loesen;
import ki.aletheia.Nehmen;
import ki.aletheia.Passen;
import ki.aletheia.Setzen;
import ki.aletheia.Umsetzen;
import ki.aletheia.Zug;

public class Generator {
    private static Bewerter[] bewerter;
    static Queue<Zug> queue;
    static Stack<Zug> liste;
    static volatile boolean stop;

    static void wake() {
        Bewerter[] bewerterArray = bewerter;
        int n = bewerter.length;
        int n2 = 0;
        while (n2 < n) {
            Bewerter b = bewerterArray[n2];
            if (b.wake()) break;
            ++n2;
        }
    }

    public static void init() {
        bewerter = new Bewerter[3];
        int i = 0;
        while (i < bewerter.length) {
            Generator.bewerter[i] = new Bewerter(i);
            ++i;
        }
    }

    public static void end() {
        Bewerter[] bewerterArray = bewerter;
        int n = bewerter.length;
        int n2 = 0;
        while (n2 < n) {
            Bewerter b = bewerterArray[n2];
            b.end();
            b.wake();
            ++n2;
        }
    }

    public static Stack<Zug> generate(Brett brett, boolean weiss, boolean firstMove) {
        return Generator.generate(brett, weiss, firstMove, weiss ? Float.MAX_VALUE : -3.4028235E38f);
    }

    public static Stack<Zug> generate(Brett brett, boolean weiss, boolean firstMove, float threshold) {
        boolean wait;
        brett.check();
        queue = new ConcurrentLinkedQueue<Zug>();
        liste = new Stack();
        stop = false;
        int i = 0;
        while (i < bewerter.length) {
            bewerter[i].start(brett, weiss, firstMove, threshold);
            ++i;
        }
        Generator.add(new Passen());
        int j = weiss ? brett.length - 1 : 0;
        block1: while (!(weiss ? j < 0 : j >= brett.length)) {
            int i2 = 0;
            while (i2 < brett.feld.length) {
                Feld f = brett.feld[i2][j];
                if (!f.loch) {
                    int y = brett.getY(i2, j);
                    int x = brett.getX(i2, j);
                    if (f.frei) {
                        if (f.s != -1 && Aletheia.weiss(f.s) == weiss) {
                            Nehmen nehmen = new Nehmen(f.s, x, y);
                            Generator.add(nehmen);
                            Generator.umsetzen(brett, weiss, firstMove, nehmen, f.s, i2, j, x, y);
                            if (stop) break block1;
                            for (Integer n : Aletheia.rots(f.s, false)) {
                                Generator.add(new Drehen(f.s, x, y, n));
                                if (stop) break block1;
                            }
                        }
                    } else if (!(!weiss ? f.z >= 0 : f.z <= 0)) {
                        if (f.s == -1) {
                            for (int s : brett.inventar) {
                                if (Aletheia.weiss(s) != weiss) continue;
                                for (Integer n : Aletheia.rots(s, true)) {
                                    Generator.add(new Setzen(s, x, y, n));
                                    if (stop) break block1;
                                }
                            }
                        } else {
                            int s = f.s;
                            if (Aletheia.weiss(s) != weiss) {
                                if (Aletheia.echt(s)) {
                                    Generator.add(new Enteignen(s, x, y));
                                    if (Aletheia.kreis(s) != -1 || Math.abs(f.z) != 1) {
                                        for (Integer n : Aletheia.rots(Aletheia.flip(s), false)) {
                                            Generator.add(new Aneignen(s, x, y, n));
                                            if (stop) break block1;
                                        }
                                        Generator.add(new Entfernen(s, x, y));
                                    }
                                } else {
                                    Generator.add(new Loesen(s, x, y));
                                    for (int n : brett.inventar) {
                                        if (Aletheia.weiss(n) != weiss) continue;
                                        for (Integer rot3 : Aletheia.rots(n, true)) {
                                            Generator.add(new Abloesen(s, n, x, y, rot3));
                                            if (stop) break block1;
                                        }
                                    }
                                }
                            } else {
                                Nehmen nehmen = new Nehmen(s, x, y);
                                Generator.add(nehmen);
                                if (Aletheia.kreis(s) != 1 || Math.abs(f.z) != 1) {
                                    for (int n : brett.inventar) {
                                        if (Aletheia.weiss(n) != weiss) continue;
                                        for (Integer rot4 : Aletheia.rots(n, true)) {
                                            Generator.add(new Ersetzen(s, n, x, y, rot4));
                                            if (stop) break block1;
                                        }
                                    }
                                }
                                Generator.umsetzen(brett, weiss, firstMove, nehmen, s, i2, j, x, y);
                                if (stop) break block1;
                                for (Integer n : Aletheia.rots(s, false)) {
                                    Generator.add(new Drehen(s, x, y, n));
                                    if (stop) break block1;
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
            j += weiss ? -1 : 1;
        }
        if (stop) {
            queue.clear();
        }
        do {
            boolean bl = wait = !queue.isEmpty();
            if (wait) {
                Generator.wake();
            } else {
                Bewerter[] bewerterArray = bewerter;
                int n = bewerter.length;
                int n2 = 0;
                while (n2 < n) {
                    Bewerter b = bewerterArray[n2];
                    if (b.working()) {
                        wait = true;
                    }
                    ++n2;
                }
            }
            if (!wait) continue;
            Thread.yield();
        } while (wait);
        if (stop) {
            return null;
        }
        liste.sort(Zug.compa(weiss));
        return liste;
    }

    private static void umsetzen(Brett brett, boolean weiss, boolean firstMove, Nehmen nehmen, int s, int i, int j, int x, int y) {
        nehmen.doZug(brett);
        brett.check();
        int i2 = 0;
        block0: while (i2 < brett.feld.length) {
            int j2 = 0;
            while (j2 < brett.feld[i2].length) {
                if (stop) break block0;
                Feld f = brett.feld[i2][j2];
                if ((i != i2 || j != j2) && !f.loch && (weiss ? f.z > 0 : f.z < 0) && f.s == -1) {
                    int x2 = brett.getX(i2, j2);
                    int y2 = brett.getY(i2, j2);
                    for (Integer rot : Aletheia.rots(s, true)) {
                        Generator.add(new Umsetzen(s, x, y, x2, y2, rot));
                    }
                }
                ++j2;
            }
            ++i2;
        }
        nehmen.undoZug(brett);
        brett.check();
    }

    private static void add(Zug z) {
        queue.add(z);
        if (queue.size() > 3) {
            Generator.wake();
        }
    }
}

