/*
 * Decompiled with CFR 0.152.
 */
package ki.aletheia;

import ki.aletheia.Brett;
import ki.aletheia.Generator;
import ki.aletheia.Zug;

final class Bewerter
implements Runnable {
    private Thread thread = new Thread(this);
    public volatile int status = 0;
    private Brett brett;
    private boolean firstMove;
    private boolean weiss;
    private double threshold;

    Bewerter(int id) {
        this.thread.setName("Bewerter " + id);
        this.thread.start();
    }

    @Override
    public void run() {
        this.sleep();
        while (this.status != -1) {
            Zug zug = Generator.queue.poll();
            if (zug == null) {
                this.sleep();
                continue;
            }
            zug.bewerte(this.brett, this.firstMove);
            if (this.weiss ? (double)zug.wert > this.threshold : (double)zug.wert < this.threshold) {
                Generator.stop = true;
                continue;
            }
            Generator.liste.add(zug);
        }
    }

    void start(Brett brett, boolean weiss, boolean firstMove, float threshold) {
        this.brett = brett.copy();
        this.firstMove = firstMove;
        this.weiss = weiss;
        this.threshold = threshold;
    }

    void end() {
        this.status = -1;
    }

    boolean working() {
        return this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wake() {
        if (!this.working()) {
            Bewerter bewerter = this;
            synchronized (bewerter) {
                this.notify();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep() {
        if (this.status == -1) {
            return;
        }
        this.status = 0;
        try {
            Bewerter bewerter = this;
            synchronized (bewerter) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.status != -1) {
            this.status = 1;
        }
    }
}

