/*
 * Decompiled with CFR 0.152.
 */
package cbge.net;

import cbge.CBError;
import cbge.net.CBClient;
import cbge.net.CBLog;
import cbge.net.CBProtocol;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.net.ftp.FTPClient;

public class CBServer {
    private static final String domainIP = "http://checkip.amazonaws.com";
    private static String ip;
    private static int port;
    static boolean run;
    private static boolean local;
    private static CBLog log;
    private static ServerSocket server;
    private static ConcurrentMap<String, CBClient> clients;

    public static void init(int port, CBLog log) {
        CBServer.log = log;
        local = port >= 0;
        if (local) {
            try {
                CBServer.port = port;
                ip = InetAddress.getLocalHost().getCanonicalHostName();
                CBServer.log(String.valueOf(CBServer.date()) + " ~ local IP addresse: " + ip);
            }
            catch (UnknownHostException e) {
                CBServer.log(String.valueOf(CBServer.date()) + " ~ unknown host");
            }
        } else {
            ip = CBProtocol.web("http://www.osyfe.de/server/ip.html");
            port = Integer.parseInt(CBProtocol.web("http://www.osyfe.de/server/port.html"));
            CBServer.log(String.valueOf(CBServer.date()) + " ~ global IP addresse: " + ip);
        }
        try {
            server = new ServerSocket(port);
            server.setSoTimeout(60000);
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBServer.init(int, CBLog)", e);
        }
        clients = new ConcurrentHashMap<String, CBClient>();
        CBServer.log(String.valueOf(CBServer.date()) + " ~ server has been established");
        run = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                CBServer.accept();
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                CBServer.process();
            }
        }).start();
    }

    private static void accept() {
        while (run) {
            try {
                String newIP;
                if (local && ip == null) {
                    try {
                        ip = InetAddress.getLocalHost().getCanonicalHostName();
                        CBServer.log(String.valueOf(CBServer.date()) + " ~ local IP addresse: " + ip);
                    }
                    catch (UnknownHostException e) {
                        CBServer.log(String.valueOf(CBServer.date()) + " ~ unknown host");
                    }
                } else if (!local && !(newIP = CBProtocol.web(domainIP)).equals(ip)) {
                    ip = newIP;
                    CBServer.upload();
                    CBServer.log(String.valueOf(CBServer.date()) + " ~ new IP addresse: " + ip);
                }
                CBClient client = new CBClient(server.accept());
                new Thread(new Runnable(){
                    CBClient client;

                    Runnable setClient(CBClient client) {
                        this.client = client;
                        return this;
                    }

                    @Override
                    public void run() {
                        try {
                            String ip = this.client.client.getInetAddress().getHostAddress();
                            CBServer.log(String.valueOf(CBServer.date()) + " ~ " + ip + " requesting");
                            String name = this.client.in.readUTF();
                            if ("".equals(name) || clients.containsKey(name)) {
                                this.client.out.writeBoolean(false);
                                this.client.close();
                                CBServer.log(String.valueOf(CBServer.date()) + " ~ request has been refused");
                            } else {
                                this.client.name = name;
                                this.client.listen();
                                this.client.out.writeBoolean(true);
                                clients.put(name, this.client);
                                CBServer.log(String.valueOf(CBServer.date()) + " ~ \"" + name + "\"" + " has joined the server");
                            }
                        }
                        catch (IOException e) {
                            CBError.error("cbge.net.CBServer.accept(): Login loop", e);
                        }
                    }
                }.setClient(client)).start();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (SocketTimeoutException client) {
            }
            catch (SocketException e) {
                CBError.error("cbge.net.CBServer.accept(): Accept loop", e);
            }
            catch (IOException e) {
                CBError.error("cbge.net.CBServer.accept(): Accept loop", e);
            }
        }
    }

    private static void process() {
        while (run) {
            boolean standby = true;
            for (CBClient client : clients.values()) {
                Set set;
                if (client.queue.isEmpty()) continue;
                standby = false;
                String data = client.queue.poll();
                CBProtocol prot = new CBProtocol(data);
                String type = prot.type;
                if ("@".equals(type)) {
                    CBClient rec = (CBClient)clients.get(prot.args[0]);
                    if (rec != null) {
                        CBProtocol at = CBProtocol.from(client.name, rec.name, prot.contents);
                        rec.send(at);
                        client.send(at);
                        continue;
                    }
                    client.send(CBProtocol.offline(prot.args[0]));
                    continue;
                }
                if ("#".equals(type)) {
                    String label = prot.args[0];
                    if ("".equals(label) || client.labels.contains(label)) {
                        CBProtocol from = CBProtocol.from(client.name, label, prot.contents);
                        for (CBClient member : clients.values()) {
                            if (!"".equals(label) && !member.labels.contains(label)) continue;
                            member.send(from);
                        }
                        continue;
                    }
                    client.send(CBProtocol.blocked(label));
                    continue;
                }
                if ("+".equals(type)) {
                    if ("".equals(prot.args[0])) continue;
                    client.labels.add(prot.args[0]);
                    continue;
                }
                if ("-".equals(type)) {
                    client.labels.remove(prot.args[0]);
                    continue;
                }
                if (":".equals(type)) {
                    set = clients.keySet();
                    client.send(CBProtocol.clients(set.toArray(new String[set.size()])));
                    continue;
                }
                if (!"&".equals(type)) continue;
                set = client.labels;
                client.send(CBProtocol.rooms(set.toArray(new String[set.size()])));
            }
            if (!standby) continue;
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void end() {
        run = false;
        for (CBClient client : clients.values()) {
            client.close();
        }
        try {
            server.close();
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBServer.end()", e);
        }
        CBServer.log(String.valueOf(CBServer.date()) + " ~ server has been shut down");
    }

    static void died(String name) {
        if (!run) {
            return;
        }
        clients.remove(name);
        CBServer.log(String.valueOf(CBServer.date()) + " ~ \"" + name + "\" has left the server");
    }

    private static void upload() {
        FTPClient client = new FTPClient();
        OutputStream out = null;
        try {
            client.connect("ftp.huth-fehre.de");
            client.login("2766-59", "bla99Blu");
            client.enterLocalPassiveMode();
            client.changeWorkingDirectory("server");
            out = client.storeFileStream("ip.html");
            out.write(ip.getBytes());
            out.close();
            client.completePendingCommand();
            client.logout();
        }
        catch (Exception e) {
            CBError.error("cbge.net.CBServer.upload(String)", e);
        }
    }

    private static String date() {
        return new SimpleDateFormat("dd.MM. HH:mm").format(new Date());
    }

    private static void log(String s) {
        log.print(s);
    }

    public static String ip() {
        return ip;
    }

    public static int port() {
        return port;
    }

    public static void main(String[] args) {
        CBServer.init(-1, new CBLog(){

            @Override
            public void print(String s) {
                System.out.println(s);
            }
        });
    }
}

