/*
 * Decompiled with CFR 0.152.
 */
package cbge.net;

import cbge.CBError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class CBProtocol {
    public static final String SEP1 = "\u0001";
    public static final String SEP2 = "\u0002";
    static final String AT = "@";
    static final String ROOM = "#";
    static final String ENTER = "+";
    static final String LEAVE = "-";
    public static final String FROM = "$";
    public static final String OFFLINE = "~";
    public static final String BLOCKED = "|";
    public static final String CLIENTS = ":";
    public static final String ROOMS = "&";
    public final String type;
    public final String[] args;
    public final String[] contents;

    public CBProtocol(String data) {
        String[] parts = data.split(SEP2, -1);
        this.type = parts[0];
        this.args = parts[1].split(SEP1, -1);
        this.contents = parts[2].split(SEP1, -1);
    }

    private CBProtocol(String type, String[] args, String ... contents) {
        boolean error = false;
        if (type.contains(SEP1) || type.contains(SEP2)) {
            error = true;
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.contains(SEP1) || arg.contains(SEP2)) {
                error = true;
            }
            ++n2;
        }
        stringArray = contents;
        n = contents.length;
        n2 = 0;
        while (n2 < n) {
            String content = stringArray[n2];
            if (content.contains(SEP1) || content.contains(SEP2)) {
                error = true;
            }
            ++n2;
        }
        if (error) {
            CBError.error("cbge.net.CBProtocol.<init>(String, String[], String[]): Separation characters are not allowed");
        }
        this.type = type;
        this.args = args;
        this.contents = contents;
    }

    public static CBProtocol clients() {
        return new CBProtocol(CLIENTS, new String[0], new String[0]);
    }

    public static CBProtocol rooms() {
        return new CBProtocol(ROOMS, new String[0], new String[0]);
    }

    public static CBProtocol at(String name, String ... contents) {
        return new CBProtocol(AT, new String[]{name}, contents);
    }

    public static CBProtocol room(String label, String ... contents) {
        return new CBProtocol(ROOM, new String[]{label}, contents);
    }

    public static CBProtocol enter(String label) {
        return new CBProtocol(ENTER, new String[]{label}, new String[0]);
    }

    public static CBProtocol leave(String label) {
        return new CBProtocol(LEAVE, new String[]{label}, new String[0]);
    }

    static CBProtocol clients(String ... names) {
        return new CBProtocol(CLIENTS, new String[0], names);
    }

    static CBProtocol rooms(String ... labels) {
        return new CBProtocol(ROOMS, new String[0], labels);
    }

    static CBProtocol from(String name, String label, String[] contents) {
        return new CBProtocol(FROM, new String[]{name, label}, contents);
    }

    static CBProtocol offline(String name) {
        return new CBProtocol(OFFLINE, new String[]{name}, new String[0]);
    }

    static CBProtocol blocked(String label) {
        return new CBProtocol(BLOCKED, new String[]{label}, new String[0]);
    }

    public String toString() {
        String str = String.valueOf(this.type) + SEP2;
        if (this.args.length > 0) {
            str = String.valueOf(str) + this.args[0];
        }
        int i = 1;
        while (i < this.args.length) {
            str = String.valueOf(str) + SEP1 + this.args[i];
            ++i;
        }
        str = String.valueOf(str) + SEP2;
        if (this.contents.length > 0) {
            str = String.valueOf(str) + this.contents[0];
        }
        i = 1;
        while (i < this.contents.length) {
            str = String.valueOf(str) + SEP1 + this.contents[i];
            ++i;
        }
        return str;
    }

    public static String intsToStr(int ... ints) {
        String str = "";
        int[] nArray = ints;
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            int inti = nArray[n2];
            int i = 0;
            while (i < 6) {
                str = String.valueOf(str) + (char)(inti >>> i * 6 & 0x3F | 0x40);
                ++i;
            }
            ++n2;
        }
        return str;
    }

    public static int[] strToInts(String str) {
        char[] cs = str.toCharArray();
        if (cs.length % 6 != 0) {
            CBError.error("cbge.net.CBProtocol.strToInts(String): Illegal format");
        }
        int[] ints = new int[cs.length / 6];
        int j = 0;
        while (j < ints.length) {
            int i = 0;
            while (i < 6) {
                int n = j;
                ints[n] = ints[n] + ((cs[i + j * 6] ^ 0x40) << i * 6);
                ++i;
            }
            ++j;
        }
        return ints;
    }

    public static String floatsToStr(float ... floats) {
        int[] ints = new int[floats.length];
        int i = 0;
        while (i < ints.length) {
            ints[i] = Float.floatToIntBits(floats[i]);
            ++i;
        }
        return CBProtocol.intsToStr(ints);
    }

    public static float[] strToFloats(String str) {
        int[] ints = CBProtocol.strToInts(str);
        float[] floats = new float[ints.length];
        int i = 0;
        while (i < ints.length) {
            floats[i] = Float.intBitsToFloat(ints[i]);
            ++i;
        }
        return floats;
    }

    static String web(String domain) {
        BufferedReader in = null;
        try {
            String content;
            URL url = new URL(domain);
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            String string = content = in.readLine();
            return string;
        }
        catch (IOException e) {
            CBError.error("cbge.net.CBProtocol.web(String)", e);
            return null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    CBError.error("cbge.net.CBProtocol.web(String)", e);
                }
            }
        }
    }
}

