/*
 * Decompiled with CFR 0.152.
 */
package cbge.graphics;

import cbge.CBError;
import cbge.graphics.CBSprite;
import cbge.graphics.Element;
import cbge.physics.CBVector;
import java.awt.Graphics2D;
import java.util.Stack;

public class CBAnimation
extends Element {
    private Stack<Element> ele = new Stack();

    public CBAnimation add(CBSprite sprite, int[] passel, int[] rep, CBVector pos, CBVector mov, double ang) {
        if (passel.length != rep.length) {
            CBError.error("cbge.graphics.CBAnimation.add(CBSprite, byte[], byte[], CBVector, CBVector): passel.length != rep.length");
        }
        sprite.passel(passel[0]);
        return this.add(new Element(sprite, passel, rep, ang), pos, mov);
    }

    public CBAnimation add(CBSprite sprite, int[] passel, CBVector pos, CBVector mov, double ang) {
        int[] rep = new int[passel.length];
        int i = 0;
        while (i < rep.length) {
            rep[i] = 1;
            ++i;
        }
        return this.add(sprite, passel, rep, pos, mov, ang);
    }

    public CBAnimation add(CBSprite sprite, int[] passel, int[] rep, CBVector pos, double ang) {
        if (passel.length != rep.length) {
            CBError.error("cbge.graphics.CBAnimation.add(CBSprite, byte[], byte[], CBVector): passel.length != rep.length");
        }
        return this.add(sprite, passel, rep, pos, new CBVector(0.0, 0.0));
    }

    public CBAnimation add(CBSprite sprite, int[] passel, CBVector pos, double ang) {
        return this.add(sprite, passel, pos, new CBVector(0.0, 0.0), ang);
    }

    public CBAnimation add(CBSprite sprite, int passel, int rep, CBVector pos, CBVector mov, double ang) {
        return this.add(sprite, new int[]{passel}, new int[]{rep}, pos, mov, ang);
    }

    public CBAnimation add(CBSprite sprite, int passel, CBVector pos, CBVector mov, double ang) {
        return this.add(sprite, passel, 1, pos, mov, ang);
    }

    public CBAnimation add(CBSprite sprite, int passel, int rep, CBVector pos, double ang) {
        return this.add(sprite, passel, rep, pos, new CBVector(0.0, 0.0), ang);
    }

    public CBAnimation add(CBSprite sprite, int passel, CBVector pos, double ang) {
        return this.add(sprite, passel, pos, new CBVector(0.0, 0.0), ang);
    }

    public CBAnimation add(CBSprite sprite, int[] passel, int[] rep, CBVector pos, CBVector mov) {
        return this.add(sprite, passel, rep, pos, mov, 0.0);
    }

    public CBAnimation add(CBSprite sprite, int[] passel, CBVector pos, CBVector mov) {
        return this.add(sprite, passel, pos, mov, 0.0);
    }

    public CBAnimation add(CBSprite sprite, int[] passel, int[] rep, CBVector pos) {
        if (passel.length != rep.length) {
            CBError.error("cbge.graphics.CBAnimation.add(CBSprite, byte[], byte[], CBVector): passel.length != rep.length");
        }
        return this.add(sprite, passel, rep, pos, new CBVector(0.0, 0.0), 0.0);
    }

    public CBAnimation add(CBSprite sprite, int[] passel, CBVector pos) {
        return this.add(sprite, passel, pos, new CBVector(0.0, 0.0), 0.0);
    }

    public CBAnimation add(CBSprite sprite, int passel, int rep, CBVector pos, CBVector mov) {
        return this.add(sprite, new int[]{passel}, new int[]{rep}, pos, mov, 0.0);
    }

    public CBAnimation add(CBSprite sprite, int passel, CBVector pos, CBVector mov) {
        return this.add(sprite, passel, 1, pos, mov, 0.0);
    }

    public CBAnimation add(CBSprite sprite, int passel, int rep, CBVector pos) {
        return this.add(sprite, passel, rep, pos, new CBVector(0.0, 0.0), 0.0);
    }

    public CBAnimation add(CBSprite sprite, int passel, CBVector pos) {
        return this.add(sprite, passel, pos, new CBVector(0.0, 0.0), 0.0);
    }

    public CBAnimation add(Element a, CBVector pos, CBVector mov) {
        a.setVectors(pos, mov);
        this.ele.push(a);
        return this;
    }

    public CBAnimation add(Element a, CBVector pos) {
        return this.add(a, pos, new CBVector(0.0, 0.0));
    }

    public boolean paint(Graphics2D g, double fps, int x, int y) {
        return this.paint(g, fps, new CBVector(x, y));
    }

    @Override
    public boolean paint(Graphics2D g, double fps, CBVector orin) {
        Stack<Element> finished = new Stack<Element>();
        for (Element e : this.ele) {
            boolean remove;
            if (e instanceof CBAnimation) {
                remove = e.paint(g, fps, orin.add(e.pos));
                e.pos = e.pos.add(this.mov.scale(1.0 / fps));
            } else {
                remove = e.paint(g, fps, orin);
            }
            if (!remove) continue;
            finished.push(e);
        }
        for (Element e : finished) {
            this.ele.remove(e);
        }
        return this.ele.empty();
    }
}

