/*
 * Decompiled with CFR 0.152.
 */
package cbge.data;

import cbge.CBError;
import cbge.data.CBStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Stack;

public class CBConf {
    private static HashMap<String, Double> werte = new HashMap();

    public static void load(String name) {
        try {
            String zeile;
            BufferedReader reader = new BufferedReader(new InputStreamReader(CBStream.get("", name)));
            Stack<String> stack = new Stack<String>();
            while ((zeile = reader.readLine()) != null) {
                if (zeile.startsWith(">")) {
                    stack.push(zeile.substring(1));
                    continue;
                }
                if (zeile.startsWith("<")) {
                    stack.pop();
                    continue;
                }
                if (!zeile.contains("#")) continue;
                String cons = zeile.split("#")[0];
                for (String s : stack) {
                    cons = String.valueOf(cons) + s;
                }
                werte.put(cons, Double.parseDouble(zeile.split("#")[1]));
            }
            reader.close();
        }
        catch (IOException e) {
            CBError.error("cbge.data.CBConf.load(String): IOException", e);
        }
    }

    public static double getCons(String name) {
        if (!werte.containsKey(name)) {
            CBError.error("cbge.data.CBConf.getCons(String): Parameter \"" + name + "\" existiert nicht");
        }
        return werte.get(name);
    }

    public static int getConsInt(String name) {
        if (!werte.containsKey(name)) {
            CBError.error("cbge.data.CBConf.getConsInt(String): Parameter \"" + name + "\" existiert nicht");
        }
        return (int)CBConf.getCons(name);
    }
}

