/*
 * Decompiled with CFR 0.152.
 */
package cbge.data;

import cbge.CBError;
import cbge.data.CBStream;
import cbge.data.CBUpdater;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

public class CBMemory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String APPENDIX = ".cbs";
    private static final Key key = new SecretKeySpec("CBMemory".getBytes(), "DES");
    private static String root;
    private static CBMemory link;
    private static HashMap<String, CBUpdater<?>> updater;
    private HashMap<String, DataObject<?>> data = new HashMap();

    static {
        updater = new HashMap();
    }

    public static void setRoot(String path) {
        root = "".equals(path) ? System.getProperty("user.dir") : path;
        link = new CBMemory();
    }

    public static boolean registry(String key, Serializable object) {
        return CBMemory.registry(key, object, null);
    }

    public static <T extends Serializable> boolean registry(String key, T object, CBUpdater<T> upd) {
        if (link != null) {
            CBMemory.link.data.put(key, new DataObject(object, null));
            if (upd != null) {
                updater.put(key, upd);
            }
            return true;
        }
        return false;
    }

    public static <T extends Serializable> T get(String key) {
        return (T)((DataObject)CBMemory.link.data.get(key)).object;
    }

    public static void remove(String key) {
        CBMemory.link.data.remove(key);
    }

    public static void save(String name) {
        if (root == null) {
            CBError.error("cbge.data.CBMemory.save(String): Der Pfad wurde noch nicht gesetzt");
        }
        String path = String.valueOf(root) + "/" + name + APPENDIX;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(1, key);
            ObjectOutputStream objectWriter = new ObjectOutputStream(new BufferedOutputStream(new CipherOutputStream(new FileOutputStream(path), cipher)));
            objectWriter.writeObject(link);
            objectWriter.close();
        }
        catch (IOException e) {
            CBError.error("cbge.data.CBMemory.save(String, String): IOException", e);
        }
        catch (Exception e) {
            CBError.error("cbge.data.CBMemory.save(String, String): Verschl\u00fcsselungsproblem", e);
        }
    }

    public static void load(String name) {
        if (root == null) {
            CBError.error("cbge.data.CBMemory.load(String): Der Pfad wurde noch nicht gesetzt");
        }
        String path = String.valueOf(root) + "/" + name + APPENDIX;
        try {
            Cipher cipher = Cipher.getInstance("DES");
            cipher.init(2, key);
            ObjectInputStream objectReader = new ObjectInputStream(new BufferedInputStream(new CipherInputStream(new FileInputStream(path), cipher)));
            link = (CBMemory)objectReader.readObject();
            objectReader.close();
        }
        catch (IOException e) {
            CBError.error("cbge.data.CBMemory.load(String, String): IOException", e);
        }
        catch (Exception e) {
            CBError.error("cbge.data.CBMemory.load(String, String): Verschl\u00fcsselungsproblem", e);
        }
        for (String key : updater.keySet()) {
            DataObject<?> ref = CBMemory.link.data.get(key);
            if (ref == null) continue;
            ((DataObject)ref).update(CBMemory.updater.get(key));
        }
    }

    public static String[] saveList() {
        if (root == null) {
            CBError.error("cbge.data.CBMemory.saveList(): Der Pfad wurde noch nicht gesetzt");
        }
        return CBStream.fileList(root, APPENDIX);
    }

    public static boolean delete(String name) {
        File f;
        if (root == null) {
            CBError.error("cbge.data.CBMemory.delete(String): Der Pfad wurde noch nicht gesetzt");
        }
        if (!(f = new File(String.valueOf(root) + "/" + name + APPENDIX)).exists()) {
            return false;
        }
        f.delete();
        return true;
    }

    private static class DataObject<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private T object;

        private DataObject(T obj) {
            this.object = obj;
        }

        private void update(CBUpdater<?> upd) {
            upd.update(this.object);
        }

        /* synthetic */ DataObject(Serializable serializable, DataObject dataObject) {
            this(serializable);
        }
    }
}

