/*
 * Decompiled with CFR 0.152.
 */
import cbge.CBError;
import cbge.CBScreen;
import cbge.CBThread;
import cbge.data.CBMemory;
import cbge.data.CBStream;
import cbge.data.CBWrapper;
import cbge.event.CBKeyAdapter;
import cbge.event.CBKeyListener;
import cbge.event.CBMouseAdapter;
import cbge.event.CBMouseListener;
import cbge.graphics.CBText;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.Date;
import java.util.Stack;
import javax.swing.JOptionPane;

public class Spiel {
    public static boolean printModus = false;
    private static Feld[] basisfelder;
    private static Satz weiss;
    private static Satz schwarz;
    private static Zustand zustand;
    private static int x;
    private static int y;
    private static int knopf;
    private static int count;
    private static int off;
    private static boolean click;
    private static boolean clickM;
    private static boolean zug;
    private static boolean ende;
    private static boolean shot;
    private static boolean offen;
    private static boolean play;
    private static boolean anaZug;
    private static boolean block;
    private static boolean flagSet;
    private static boolean save;
    private static int w;
    private static int h;
    private static int radius;
    private static Stein hand;
    private static Feld genommen;
    private static SteinListener sl;
    private static CBMouseListener ml;
    private static CBKeyListener kl;
    private static String loaded;
    private static double zeitWeiss;
    private static double zeitSchwarz;
    private static long drawTime;
    private static Thread painter;

    static {
        zustand = new Zustand();
        drawTime = System.currentTimeMillis();
        painter = new Thread(() -> {
            while (drawTime > 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - drawTime <= 500L) continue;
                Spiel.draw();
            }
        });
    }

    static void draw() {
        try {
            CBScreen.draw();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (drawTime > 0L) {
            drawTime = System.currentTimeMillis();
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length > 1) {
                CBScreen.build(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            } else {
                CBScreen.buildFull();
            }
            painter.start();
            CBWrapper.setKey("Sagitto");
            w = CBScreen.getWidth();
            h = CBScreen.getHeight();
            count = 0;
            Spiel.menu();
            drawTime = -1L;
            CBScreen.destroy();
        }
        catch (Exception e) {
            CBError.error("Spiel.main(String[])", e);
            System.exit(0);
        }
    }

    private static void menu() {
        CBKeyAdapter mkl = new CBKeyAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void keyPressed(int k) {
                if (k == 27) {
                    ende = true;
                }
            }
        };
        CBMouseAdapter mml = new CBMouseAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void mousePressed(MouseEvent me) {
                x = me.getX();
                y = me.getY();
                clickM = true;
            }

            @Override
            public void mouseWheel(int r) {
                int i = Math.min(2, CBScreen.getMouseX() * 3 / CBScreen.getWidth());
                int[] o = new int[]{off % 1000, off / 1000 % 1000, off / 1000000 % 1000};
                o[i] = Math.max(0, o[i] + r);
                off = o[0] + o[1] * 1000 + o[2] * 1000000;
            }
        };
        CBScreen.addKeyListener(mkl);
        CBScreen.addMouseListener(mml);
        Graphics2D g = CBScreen.getGraphics();
        ende = false;
        clickM = false;
        int dist = CBScreen.getWidth() / 3;
        int h = (CBScreen.getHeight() - 5) / 30 - 2;
        int[] choi = new int[]{-1, -1, -1};
        while (!ende) {
            String[][] list = new String[][]{CBStream.fileList("Felder", ".txt", false), CBStream.fileList("Saetze", ".txt", false), CBStream.fileList("Save/Pakete", ".cbp", true)};
            int[] o = new int[]{off % 1000, off / 1000 % 1000, off / 1000000 % 1000};
            int i = 0;
            while (i < 3) {
                o[i] = Math.min(list[i].length - 1, o[i]);
                ++i;
            }
            off = o[0] + o[1] * 1000 + o[2] * 1000000;
            if (clickM) {
                i = x / dist;
                int j = (y - 70) / 30 - 1;
                if (j >= h - 2) {
                    if (i == 0 && choi[0] != -1) {
                        Spiel.bg(g);
                        try {
                            Feld.build("Felder/" + list[0][choi[0]] + ".txt")[0].repaint();
                        }
                        catch (Exception e) {
                            CBError.error("Spiel.menu()", e);
                        }
                        while (!ende) {
                            try {
                                Spiel.draw();
                                Thread.sleep(100L);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                    if (i == 1) {
                        CBScreen.removeMouseListener(mml);
                        CBScreen.removeKeyListener(mkl);
                        String name = choi[1] != -1 ? "Saetze/" + list[1][choi[1]] + ".txt" : "Saetze/Neu.txt";
                        Spiel.satz(name, choi[1] == -1);
                        CBScreen.addMouseListener(mml);
                        CBScreen.addKeyListener(mkl);
                    }
                    if (i == 2) {
                        boolean akt;
                        CBScreen.removeMouseListener(mml);
                        CBScreen.removeKeyListener(mkl);
                        boolean ng = choi[0] != -1 && choi[1] != -1;
                        boolean bl = akt = CBStream.fileList("Save", ".cbs", false).length > 0;
                        if (choi[2] != -1 || !ng && akt) {
                            Spiel.altesSpiel(choi[2] != -1 ? list[2][choi[2]] : null);
                        } else if (ng) {
                            Spiel.neuesSpiel(list[0][choi[0]], list[1][choi[1]]);
                        }
                        CBScreen.addMouseListener(mml);
                        CBScreen.addKeyListener(mkl);
                    }
                } else if (j >= 0 && j + o[i] < list[i].length) {
                    if (choi[i] != j + o[i]) {
                        choi[i] = j + o[i];
                        if (i < 2) {
                            choi[2] = -1;
                        }
                        if (i == 2) {
                            choi[1] = -1;
                            choi[0] = -1;
                        }
                        if (i == 0 && choi[1] == -1) {
                            int k = 0;
                            while (k < list[1].length) {
                                if (list[1][k].equals(list[0][choi[0]])) {
                                    choi[1] = k;
                                }
                                ++k;
                            }
                        }
                    } else {
                        choi[i] = -1;
                    }
                }
                ende = false;
                clickM = false;
            }
            Spiel.bg(g);
            Farbe.basic(g, 2);
            g.setFont(new Font("Andalus", 0, 40));
            ((Graphics)g).drawString("amakta", (w - CBText.width("amakta")) / 2, 45);
            g.setFont(new Font("", 0, 20));
            ((Graphics)g).drawString("Feld", (dist - CBText.width("Feld")) / 2, 90);
            ((Graphics)g).drawString("Satz", (dist - CBText.width("Satz")) / 2 + dist, 90);
            ((Graphics)g).drawString("Partie", (dist - CBText.width("Partie")) / 2 + dist * 2, 90);
            g.drawLine(0, 95, w, 95);
            int k = 0;
            while (k < 3) {
                if (k > 0) {
                    Farbe.basic(g, 2);
                    g.drawLine(dist * k, 60, dist * k, CBScreen.getHeight());
                }
                int q = 0;
                while (q + o[k] < list[k].length && q < h - 2) {
                    if (q + o[k] == choi[k]) {
                        Farbe.basic(g, 3);
                    } else {
                        Farbe.basic(g, 2);
                    }
                    ((Graphics)g).drawString(list[k][q + o[k]], 30 + dist * k, (q + 4) * 30);
                    ++q;
                }
                ++k;
            }
            Farbe.basic(g, 2);
            g.drawLine(0, (h - 1) * 30 + 65, CBScreen.getWidth(), (h - 1) * 30 + 65);
            String[] wort = new String[]{"Feld ansehen", "Satz bearbeiten", "Neuer Satz", "Partie laden", "Neue Partie", "Partie fortsetzen"};
            AttributedString[] attr = new AttributedString[wort.length];
            int k2 = 0;
            while (k2 < wort.length) {
                attr[k2] = new AttributedString(wort[k2]);
                attr[k2].addAttribute(TextAttribute.FONT, g.getFont());
                attr[k2].addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                ++k2;
            }
            if (choi[0] != -1) {
                ((Graphics)g).drawString(attr[0].getIterator(), 30, h * 30 + 60);
            }
            if (choi[1] != -1) {
                ((Graphics)g).drawString(attr[1].getIterator(), 30 + dist, h * 30 + 60);
            } else {
                ((Graphics)g).drawString(attr[2].getIterator(), 30 + dist, h * 30 + 60);
            }
            if (choi[2] != -1) {
                ((Graphics)g).drawString(attr[3].getIterator(), 30 + dist * 2, h * 30 + 60);
            } else if (choi[0] != -1 && choi[1] != -1) {
                ((Graphics)g).drawString(attr[4].getIterator(), 30 + dist * 2, h * 30 + 60);
            } else if (CBStream.fileList("Save", ".cbs", false).length > 0) {
                ((Graphics)g).drawString(attr[5].getIterator(), 30 + dist * 2, h * 30 + 60);
            }
            Spiel.draw();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void satz(String name, boolean neu) {
        new Satz(name);
        if (neu) {
            boolean boo;
            CBScreen.defocus();
            do {
                boo = false;
                name = JOptionPane.showInputDialog("Name des Satzes:");
                if (name == null) continue;
                String[] stringArray = CBStream.fileList("Saetze", ".txt");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String satz = stringArray[n2];
                    if (satz.equals(name) && JOptionPane.showConfirmDialog(null, "\u00fcberschreiben?", "Dieser Name existiert bereits!", 0) == 1) {
                        boo = true;
                    }
                    ++n2;
                }
            } while (boo);
            if (name != null && !name.isEmpty()) {
                File f = new File("Saetze/" + name + ".txt");
                if (f.exists()) {
                    f.delete();
                }
                new File("Saetze/Neu.txt").renameTo(f);
            }
            CBScreen.focus();
        }
    }

    private static void altesSpiel(String load) {
        if (load != null) {
            loaded = load;
            Spiel.dewrapp(load);
        }
        Spiel.save();
        Spiel.load("1w");
        Spiel.zustand.z = 0;
        play = false;
        Spiel.spiel();
        loaded = null;
    }

    private static void neuesSpiel(String feld, String satz) {
        try {
            basisfelder = Feld.build("Felder/" + feld + ".txt");
            radius = Feld.radius * 5 / 4;
            weiss = new Satz(true, "Saetze/" + satz + ".txt");
            schwarz = new Satz(false, "Saetze/" + satz + ".txt");
            Spiel.zustand.z = -1;
            Spiel.kreise();
            if (knopf == -1) {
                return;
            }
            Spiel.zustand.z = 0;
            String[] stringArray = CBStream.fileList("Save", ".cbs");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String zug = stringArray[n2];
                new File("Save/" + zug + ".cbs").delete();
                ++n2;
            }
            Spiel.save();
            CBMemory.save("1w");
            play = true;
            Spiel.spiel();
        }
        catch (Exception e) {
            CBError.error("Spiel.neuesSpiel(String, String)", e);
        }
    }

    private static void spiel() {
        String name;
        boolean boo;
        hand = null;
        genommen = null;
        ende = false;
        zug = true;
        anaZug = true;
        offen = false;
        block = false;
        flagSet = false;
        save = false;
        count = 1;
        zeitSchwarz = 0.0;
        zeitWeiss = 0.0;
        kl = new CBKeyAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void keyPressed(int k) {
                if (k == 40 && block) {
                    block = false;
                    return;
                }
                if (block) {
                    return;
                }
                if (k == 27) {
                    ende = true;
                }
                if (!offen && hand == null) {
                    switch (k) {
                        case 74: {
                            zustand.z = 1;
                            break;
                        }
                        case 75: {
                            zustand.z = 2;
                            break;
                        }
                        case 76: {
                            zustand.z = 3;
                            break;
                        }
                        case 73: {
                            zustand.z = 0;
                            break;
                        }
                        case 37: {
                            Spiel.backLoop();
                            break;
                        }
                        case 39: {
                            Spiel.forwardLoop();
                            break;
                        }
                        case 10: {
                            Spiel.zugende();
                            break;
                        }
                        case 8: {
                            Spiel.restore();
                            break;
                        }
                        case 65: {
                            play = !play;
                            break;
                        }
                        case 83: {
                            Farbe.oldStyle = !Farbe.oldStyle;
                            break;
                        }
                        case 81: {
                            if (!CBScreen.isPressed(17)) break;
                            printModus = !printModus;
                            break;
                        }
                        case 87: {
                            if (!CBScreen.isPressed(17)) break;
                            Spiel.platziere();
                            break;
                        }
                        case 69: {
                            if (!CBScreen.isPressed(17)) break;
                            Spiel.spiegele();
                        }
                    }
                }
                if (!offen && hand != null) {
                    switch (k) {
                        case 37: {
                            hand.turn(-1);
                            break;
                        }
                        case 39: {
                            hand.turn(1);
                            break;
                        }
                        case 40: {
                            hand.turn(0);
                        }
                    }
                }
                if (k == 38 && !offen) {
                    Spiel.open();
                }
                if (k == 40 && offen) {
                    Spiel.close();
                }
                if (k == 32) {
                    shot = true;
                }
            }
        };
        ml = new CBMouseAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void mousePressed(MouseEvent me) {
                if (block) {
                    return;
                }
                int x = me.getX();
                int y = me.getY();
                if (hand != null) {
                    if (me.getButton() == 2) {
                        hand.turn(0);
                    } else if (me.getButton() == 3) {
                        if (hand.echt()) {
                            (zug ? weiss : schwarz).add(hand);
                        }
                        Spiel.clearHand();
                    }
                } else if (!offen) {
                    if (me.getButton() == 1 && x < 120 && y < 50) {
                        Spiel.zugende();
                    } else if (me.getButton() == 1 && x > w - 120 && y < 50) {
                        play = !play;
                    } else if (me.getButton() == 3) {
                        Spiel.open();
                    } else if (me.getButton() == 2) {
                        Spiel.restore();
                    }
                }
                if (me.getButton() == 1) {
                    Feld f = basisfelder[0].click(x, y);
                    if (f == null) {
                        return;
                    }
                    boolean z = f.zustand == 3 && zug || f.zustand == 4 && !zug;
                    Stein s = f.stein();
                    if (hand == null) {
                        if (s == null) {
                            return;
                        }
                        if (s.weiss() == zug) {
                            if (f.zustand == 1 || z) {
                                genommen = f;
                                hand = s;
                                f.stein(null);
                            }
                        } else if (z) {
                            if (!s.echt()) {
                                f.stein(null);
                            } else {
                                s.flip();
                            }
                        }
                    } else if (s == null && (z || f == genommen)) {
                        f.stein(hand);
                        Spiel.clearHand();
                    }
                }
            }

            @Override
            public void mouseWheel(int r) {
                if (hand != null) {
                    hand.turn(r);
                } else if (!offen) {
                    if (r == 1) {
                        Spiel.back();
                    } else if (r == -1) {
                        Spiel.forward();
                    }
                }
            }
        };
        sl = new SteinListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void stein(Stein s, int button) {
                if (button == 1 && zug == s.weiss()) {
                    Spiel.close();
                    hand = s;
                    (zug ? weiss : schwarz).remove(s);
                }
            }
        };
        CBScreen.addKeyListener(kl);
        CBScreen.addMouseListener(ml);
        Graphics2D g = CBScreen.getGraphics();
        new CBThread(){

            @Override
            public void work(double fps) {
                if (play && zustand.z == 0) {
                    if (zug) {
                        zeitWeiss = zeitWeiss + 1.0 / fps;
                    } else {
                        zeitSchwarz = zeitSchwarz + 1.0 / fps;
                    }
                }
                if (ende) {
                    this.stop();
                }
            }
        }.start();
        while (!ende) {
            try {
                if (offen) {
                    if (!click) {
                        Satz satz;
                        click = true;
                        CBScreen.removeMouseListener(ml);
                        Satz satz2 = satz = zug ? weiss : schwarz;
                        if (hand != null) {
                            if (hand.echt()) {
                                satz.add(hand);
                            }
                            Spiel.clearHand();
                        }
                        satz.open(sl, zug ? schwarz : weiss);
                    }
                } else {
                    basisfelder[0].check();
                    Spiel.paintBackground(g);
                    basisfelder[zug ? 0 : 1].repaint();
                    if (hand != null) {
                        hand.paint(g, CBScreen.getMouseX(), CBScreen.getMouseY(), radius);
                    }
                    if (!printModus) {
                        Farbe.paintFlagge(g, Spiel.zustand.z);
                    }
                    Spiel.draw();
                }
                Stein s = basisfelder[0].stein();
                if (!(printModus || s == null || s.weiss() || flagSet)) {
                    Spiel.zustand.z = 1;
                    flagSet = true;
                }
                s = basisfelder[1].stein();
                if (!printModus && s != null && s.weiss() && !flagSet) {
                    Spiel.zustand.z = 3;
                    flagSet = true;
                }
                if (shot) {
                    CBScreen.screenShot("Screenshots/" + new Date().toString().replaceAll(":", "_"));
                    shot = false;
                    if (!offen) {
                        Farbe.satz(g);
                    } else {
                        Farbe.feld(g, 1);
                    }
                    g.setFont(new Font("", 0, 80));
                    g.drawString("Screenshot erstellt", (w - CBText.width("Screenshot erstellt")) / 2, h / 2);
                    Spiel.draw();
                    Thread.sleep(1500L);
                }
                Thread.sleep(25L);
            }
            catch (Exception s) {
                // empty catch block
            }
        }
        CBScreen.removeKeyListener(kl);
        CBScreen.removeMouseListener(ml);
        if (!save) {
            return;
        }
        CBScreen.defocus();
        do {
            boo = false;
            name = JOptionPane.showInputDialog(null, "Name des Spiels:", loaded == null ? "" : loaded);
            if (name != null && !name.equals(loaded)) {
                String[] stringArray = CBStream.fileList("Save/Pakete", ".cbp");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String spiel = stringArray[n2];
                    if (spiel.equals(name) && JOptionPane.showConfirmDialog(null, "\ufffdberschreiben?", "Dieser Name existiert bereits!", 0) == 1) {
                        boo = true;
                    }
                    ++n2;
                }
            }
            if (name == null || !name.isEmpty()) continue;
            if (JOptionPane.showConfirmDialog(null, "Nicht speichern?", "Kein Name eingegeben!", 0) == 1) {
                boo = true;
                continue;
            }
            name = null;
        } while (boo && name != null);
        if (name != null) {
            Spiel.wrapp(name);
        }
        CBScreen.focus();
    }

    private static void platziere() {
        Stack<Stein> s = new Stack<Stein>();
        Stein[] steinArray = Spiel.weiss.satz;
        int n = Spiel.weiss.satz.length;
        int n2 = 0;
        while (n2 < n) {
            Stein sw = steinArray[n2];
            s.push(sw);
            ++n2;
        }
        steinArray = Spiel.schwarz.satz;
        n = Spiel.schwarz.satz.length;
        n2 = 0;
        while (n2 < n) {
            Stein ss = steinArray[n2];
            s.push(ss);
            ++n2;
        }
        basisfelder[0].platziere(s);
    }

    private static void spiegele() {
        basisfelder[0].spiegele();
    }

    private static void bg(Graphics g) {
        Farbe.basic(g, 1);
        g.fillRect(0, 0, w, h);
    }

    private static void paintBackground(Graphics g) {
        Spiel.bg(g);
        Farbe.satz(g);
        g.fillRect(0, 0, 120, 50);
        g.fillRect(w - 120, 0, 120, 50);
        Farbe.basic(g, zug ? 3 : 2);
        g.setFont(new Font("", 30, 30));
        g.drawString(String.valueOf(count), 30, 35);
        Farbe.basic(g, !play && anaZug ? 3 : 2);
        g.drawString(play ? "Spiel" : "Analyse", w - CBText.width("Analyse") - 5, 35);
        if (play) {
            int y = h - 10;
            int z = (int)zeitWeiss;
            int s = z % 60;
            int m = z / 60 % 60;
            int h = z / 3600;
            String ss = String.valueOf(s < 10 ? "0" : "") + s;
            String sm = String.valueOf(m < 10 ? "0" : "") + m;
            String sh = String.valueOf(h);
            String sz = String.valueOf(sh) + ":" + sm + ":" + ss;
            g.drawString(sz, 10, y);
            z = (int)zeitSchwarz;
            s = z % 60;
            m = z / 60 % 60;
            h = z / 3600;
            ss = String.valueOf(s < 10 ? "0" : "") + s;
            sm = String.valueOf(m < 10 ? "0" : "") + m;
            sh = String.valueOf(h);
            sz = String.valueOf(sh) + ":" + sm + ":" + ss;
            g.drawString(sz, w - CBText.width(sz) - 10, y);
        }
    }

    static void clearHand() {
        hand = null;
        genommen = null;
    }

    static void open() {
        offen = true;
        click = false;
    }

    static void close() {
        if (Spiel.zustand.z == -1) {
            return;
        }
        offen = false;
        (zug ? weiss : schwarz).close();
        CBScreen.addMouseListener(ml);
    }

    static void zugende() {
        Spiel.clearHand();
        if ((zug = !zug) && play) {
            ++count;
            anaZug = zug;
        }
        if (play) {
            CBMemory.save(String.valueOf(count) + (zug ? "w" : "s"));
            save = true;
        }
    }

    private static void load(String name) {
        CBMemory.load(name);
        radius = Feld.radius * 5 / 4;
        basisfelder[0].position();
    }

    static void restore() {
        if (!play) {
            zug = anaZug;
        }
        Spiel.load(String.valueOf(count) + (zug ? "w" : "s"));
    }

    static void back() {
        if (count == 1 && zug) {
            return;
        }
        if (!(zug = !zug)) {
            --count;
        }
        anaZug = zug;
        Spiel.load(String.valueOf(count) + (zug ? "w" : "s"));
    }

    static void backLoop() {
        Spiel.back();
        new Thread(() -> {
            long t = System.currentTimeMillis();
            while (CBScreen.isPressed(37) && System.currentTimeMillis() - t < 1500L) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CBScreen.isPressed(37) && hand == null && !offen) {
                block = true;
                while (!(count == 1 && zug || ende || !block)) {
                    Spiel.back();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                block = false;
            }
        }).start();
    }

    static void forward() {
        if (CBMemory.saveList().length < count * 2 + (zug ? 0 : 1)) {
            return;
        }
        if (zug = !zug) {
            ++count;
        }
        anaZug = zug;
        Spiel.load(String.valueOf(count) + (zug ? "w" : "s"));
    }

    static void forwardLoop() {
        Spiel.forward();
        new Thread(() -> {
            long t = System.currentTimeMillis();
            while (CBScreen.isPressed(39) && System.currentTimeMillis() - t < 1500L) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CBScreen.isPressed(39) && hand == null && !offen) {
                block = true;
                int l = CBMemory.saveList().length;
                while (l >= count * 2 + (zug ? 0 : 1) && !ende && block) {
                    Spiel.forward();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                block = false;
            }
        }).start();
    }

    private static void kreise() {
        CBKeyAdapter end = new CBKeyAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void keyPressed(int k) {
                if (k == 10) {
                    ende = true;
                }
                if (k == 27) {
                    ende = true;
                    knopf = -1;
                }
            }
        };
        SteinListener l = new SteinListener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void stein(Stein s, int button) {
                hand = s;
                knopf = button;
            }
        };
        CBScreen.addKeyListener(end);
        weiss.open(l, schwarz);
        knopf = 0;
        hand = null;
        ende = false;
        while (!ende) {
            if (knopf > 0 && hand != null) {
                if (knopf == 1) {
                    hand.up();
                } else if (knopf == 3) {
                    hand.down();
                }
                knopf = 0;
                hand = null;
                weiss.paint(CBScreen.getGraphics(), Spiel.schwarz.satz);
            }
            try {
                Thread.sleep(25L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        weiss.close();
        CBScreen.removeKeyListener(end);
    }

    private static void wrapp(String name) {
        new File("Save/Pakete/" + name).mkdirs();
        String[] stringArray = CBMemory.saveList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String zug = stringArray[n2];
            CBStream.copyFile("Save/" + zug + ".cbs", "Save/Pakete/" + name);
            ++n2;
        }
        CBWrapper.wrapp("Save/Pakete", name, true);
    }

    private static void dewrapp(String name) {
        String zug;
        CBWrapper.dewrapp("Save/Pakete", name, false);
        String[] stringArray = CBStream.fileList("Save", ".cbs");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            zug = stringArray[n2];
            new File("Save/" + zug + ".cbs").delete();
            ++n2;
        }
        stringArray = CBStream.fileList("Save/Pakete/" + name, ".cbs");
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            zug = stringArray[n2];
            CBStream.copyFile("Save/Pakete/" + name + "/" + zug + ".cbs", "Save");
            ++n2;
        }
        File f = new File("Save/Pakete/" + name);
        File[] fileArray = f.listFiles();
        int n3 = fileArray.length;
        n = 0;
        while (n < n3) {
            File d = fileArray[n];
            d.delete();
            ++n;
        }
        f.delete();
    }

    private static void save() {
        CBMemory.setRoot("Save");
        CBMemory.registry("Basisfelder", basisfelder, bf -> {
            basisfelder = bf;
            Feld[] feldArray = basisfelder;
        });
        CBMemory.registry("Weisser Satz", weiss, w -> {
            Satz satz = weiss = w;
        });
        CBMemory.registry("Schwarzer Satz", schwarz, s -> {
            Satz satz = schwarz = s;
        });
        CBMemory.registry("Radius", radius, r -> {
            int n = radius = r.intValue();
        });
        CBMemory.registry("Zustand", zustand, z -> {
            Zustand zustand = zustand = z;
        });
    }

    private static class Zustand
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int z;

        private Zustand() {
        }
    }
}

