/*
 * Decompiled with CFR 0.152.
 */
package cbge.graphics;

import cbge.CBError;
import cbge.CBScreen;
import cbge.data.CBMemory;
import cbge.data.CBStream;
import cbge.physics.CBVector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class CBSprite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String format = ".png";
    private static HashMap<String, SpriteSheet> sprites;
    private static HashMap<String, SpriteSheet> before;
    private static transient HashMap<String, int[]> dimensions;
    private static transient String root;
    private static boolean updated;
    private transient SpriteSheet link;
    private String name;
    private byte passel = 0;
    private byte step = 0;
    private int x;
    private int y;
    private double state = 0.0;
    private double speed;
    private boolean flip = false;
    private transient BufferedImage rot;

    static {
        updated = false;
    }

    public static void setRoot(String path) {
        root = path == null ? "" : path;
        dimensions = new HashMap();
        sprites = new HashMap();
        CBMemory.registry("cbge.graphics.CBSprite.sprites", sprites, s -> {
            before = sprites;
            sprites = s;
            CBSprite.update(true);
        });
    }

    public static void update(boolean intern) {
        if (sprites != null) {
            if (!intern) {
                updated = true;
            }
            if (updated && before != null) {
                for (String key : before.keySet()) {
                    if (sprites.containsKey(key)) continue;
                    before.remove(key);
                }
                for (String key : sprites.keySet()) {
                    if (before.containsKey(key)) {
                        sprites.replace(key, before.get(key));
                        before.remove(key);
                        continue;
                    }
                    int[] dim = dimensions.get(key);
                    if (dim == null) {
                        CBError.error("cbge.grphics.CBSprite.update(Boolean): Bildgr\u00f6\u00dfe von " + key + " noch nicht angegeben");
                    }
                    CBSprite.sprites.get(key).update(dim[0], dim[1]);
                }
                updated = false;
                before = null;
            }
        }
    }

    public static void setDim(String nickName, int width, int height) {
        dimensions.put(nickName, new int[]{width, height});
    }

    public static void load(String path, String fileName) {
        CBSprite.load(path, fileName, fileName);
    }

    public static void load(String path, String fileName, String nickName) {
        try {
            String sprite;
            BufferedReader info = new BufferedReader(new InputStreamReader(CBStream.get(CBSprite.combine(root, path), "info.txt")));
            while ((sprite = info.readLine()) != null) {
                String[] data;
                if (sprite.contains("\\\t") || (data = sprite.split("\\\t")).length != 3 || !data[0].equals(fileName)) continue;
                int[] dim = dimensions.get(nickName);
                if (dim == null) {
                    CBError.error("cbge.grphics.CBSprite.load(String, String, String): Bildgr\u00f6\u00dfe von " + nickName + " noch nicht angegeben");
                }
                sprites.put(nickName, new SpriteSheet(path, fileName, Byte.parseByte(data[1]), Byte.parseByte(data[2]), dim[0], dim[1]));
                break;
            }
            info.close();
        }
        catch (Exception e) {
            CBError.error("cbge.grphics.CBSprite.load(String, String, String): Ordner " + CBSprite.combine(root, path) + " oder Datei 'info.txt' nicht vorhanden oder fehlerhaft", e);
        }
    }

    public static void abandon(String name) {
        CBSprite.sprites.get(name).flush();
        sprites.remove(name);
    }

    public CBSprite(String name) {
        this(name, 0.0);
    }

    public CBSprite(String name, double speed) {
        this.name = name;
        this.speed = speed;
    }

    private SpriteSheet link() {
        if (this.link == null) {
            this.link = sprites.get(this.name);
        }
        if (this.link == null) {
            CBError.error("cbge.graphics.CBSprite.link(): SpriteSheet " + this.name + " ist nicht geladen");
        }
        return this.link;
    }

    public void passel(int passel) {
        this.passel = (byte)(passel % this.link().passel);
    }

    public byte passel() {
        return this.passel;
    }

    public void setX(int x) {
        this.step = (byte)(x % this.link().steps);
    }

    public void setY(int y) {
        this.passel(y);
    }

    public boolean flip() {
        this.flip = !this.flip;
        return this.flip;
    }

    public boolean paintTrans(Graphics2D g, double fps, double ang, double scale, CBVector v) {
        return this.paintTrans(g, fps, ang, scale, v.getInt(0), v.getInt(1));
    }

    public boolean paintTrans(Graphics2D g, double fps, double ang, double scale, int x, int y) {
        double width = this.link().width;
        double height = this.link().height;
        double sc = Math.abs(scale);
        int w1 = (int)Math.ceil(Math.abs(Math.cos(ang) * width - Math.sin(ang) * height) * sc);
        int h1 = (int)Math.ceil(Math.abs(Math.sin(ang) * width + Math.cos(ang) * height) * sc);
        int w2 = (int)Math.ceil(Math.abs(Math.cos(ang) * width + Math.sin(ang) * height) * sc);
        int h2 = (int)Math.ceil(Math.abs(-Math.sin(ang) * width + Math.cos(ang) * height) * sc);
        int w = Math.max(w1, w2);
        w += w % 2;
        int h = Math.max(h1, h2);
        h += h % 2;
        w2 = w / 2;
        h2 = h / 2;
        BufferedImage rot = new BufferedImage(w, h, 2);
        Graphics2D g2 = rot.createGraphics();
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, w, h);
        AffineTransform at = new AffineTransform();
        at.translate(w2, h2);
        if (scale != 1.0) {
            at.scale(scale, sc);
        }
        if (ang != 0.0) {
            at.rotate(ang);
        }
        at.translate(-w2, -h2);
        g2.setTransform(at);
        boolean ret = this.paint(g2, fps, x, y, x - (int)(((double)w - width) / 2.0), y - (int)(((double)h - height) / 2.0), true);
        g2.dispose();
        g.drawImage(rot, null, x - w2, y - h2);
        if (this.rot != null) {
            this.rot.flush();
        }
        this.rot = rot;
        return ret;
    }

    public void paint(Graphics2D g, CBVector v) {
        this.paint(g, 0.0, v);
    }

    public boolean paint(Graphics2D g, double fps, CBVector v) {
        return this.paint(g, fps, v.getInt(0), v.getInt(1));
    }

    public void paint(Graphics2D g, int x, int y) {
        this.paint(g, 0.0, x, y);
    }

    public boolean paint(Graphics2D g, double fps, int x, int y) {
        return this.paint(g, fps, x, y, this.link().width / 2, this.link().height / 2, false);
    }

    private boolean paint(Graphics2D g, double fps, int x, int y, int cx, int cy, boolean rot) {
        boolean ret = false;
        if (Double.isNaN(fps)) {
            this.step = 0;
        } else if (fps != 0.0) {
            this.state += this.speed / Math.abs(fps) * (double)this.link().steps;
        }
        while (this.state > 1.0) {
            this.state -= 1.0;
            this.step = fps > 0.0 ? (byte)(this.step + 1) : (byte)(this.step - 1);
            boolean cycle = true;
            if (this.step >= this.link().steps) {
                this.step = 0;
            } else if (this.step < 0) {
                this.step = (byte)(this.link().steps - 1);
            } else {
                cycle = false;
            }
            if (!cycle) continue;
            ret = true;
        }
        g.drawImage(this.link().pics[this.passel][this.step], null, x - cx, y - cy);
        this.x = x;
        this.y = y;
        if (this.rot != null && !rot) {
            this.rot.flush();
            this.rot = null;
        }
        return ret;
    }

    private int xmin() {
        BufferedImage ref = this.rot == null ? this.link().pics[0][0] : this.rot;
        return Math.max(this.x - ref.getWidth() / 2, 0);
    }

    private int xmax() {
        BufferedImage ref = this.rot == null ? this.link().pics[0][0] : this.rot;
        return Math.min(this.x + ref.getWidth() / 2, CBScreen.getWidth());
    }

    private int ymin() {
        BufferedImage ref = this.rot == null ? this.link().pics[0][0] : this.rot;
        return Math.max(this.y - ref.getHeight() / 2, 0);
    }

    private int ymax() {
        BufferedImage ref = this.rot == null ? this.link().pics[0][0] : this.rot;
        return Math.min(this.y + ref.getHeight() / 2, CBScreen.getHeight());
    }

    private int touch(int i, int j) {
        BufferedImage ref = this.rot == null ? this.link().pics[this.passel][this.step] : this.rot;
        return ref.getRGB(i - this.x + ref.getWidth() / 2, j - this.y + ref.getHeight() / 2);
    }

    public int touch(CBSprite s) {
        if (s == null) {
            return -1;
        }
        int xmin = Math.max(this.xmin(), s.xmin());
        int xmax = Math.min(this.xmax(), s.xmax());
        int ymin = Math.max(this.ymin(), s.ymin());
        int ymax = Math.min(this.ymax(), s.ymax());
        int i = xmin;
        while (i < xmax) {
            int j = ymin;
            while (j < ymax) {
                if (this.touch(i, j) != 0 && s.touch(i, j) != 0) {
                    return (i << 13) + j;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public static int getX(int touch) {
        return touch >> 13;
    }

    public static int getY(int touch) {
        return touch % 8192;
    }

    public boolean onScreen() {
        return this.xmin() < CBScreen.getWidth() && this.xmax() >= 0 && this.ymin() < CBScreen.getHeight() && this.ymax() >= 0;
    }

    public boolean onScreen(CBVector v) {
        int tX = this.x;
        int tY = this.y;
        this.x = v.getInt(0);
        this.y = v.getInt(1);
        boolean on = this.onScreen();
        this.x = tX;
        this.y = tY;
        return on;
    }

    private static String combine(String a, String b) {
        if ("".equals(a)) {
            return b;
        }
        if ("".equals(b)) {
            return a;
        }
        return String.valueOf(a) + "/" + b;
    }

    private static final class SpriteSheet
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String path;
        private String name;
        private byte passel;
        private byte steps;
        private int width;
        private int height;
        private transient BufferedImage[][] pics;

        private SpriteSheet(String path, String name, byte passel, byte steps, int width, int height) {
            this.path = path;
            this.name = name;
            this.passel = passel;
            this.steps = steps;
            this.update(width, height);
        }

        private void update(int width, int height) {
            this.width = width;
            this.height = height;
            BufferedImage im = null;
            try {
                InputStream s = CBStream.get(CBSprite.combine(root, this.path), String.valueOf(this.name) + CBSprite.format);
                im = ImageIO.read(s);
                s.close();
            }
            catch (IOException e) {
                CBError.error("cbge.graphics.CBSprite.SpriteSheet.new(String, String, int, int): " + CBSprite.combine(root, this.path) + "/" + this.name + " ist kein " + CBSprite.format + "-Bild", e);
                return;
            }
            BufferedImage bi = new BufferedImage(width * this.steps, height * this.passel, 1);
            Graphics2D g = bi.createGraphics();
            g.drawImage(im.getScaledInstance(width * this.steps, height * this.passel, 2), 0, 0, CBScreen.getObserver());
            g.dispose();
            this.pics = new BufferedImage[this.passel][this.steps];
            int i = 0;
            while (i < this.passel) {
                int j = 0;
                while (j < this.steps) {
                    this.pics[i][j] = new BufferedImage(width, height, 2);
                    g = this.pics[i][j].createGraphics();
                    g.drawImage((Image)bi.getSubimage(j * width, i * height, width, height), 0, 0, CBScreen.getObserver());
                    g.dispose();
                    int k = 0;
                    while (k < width) {
                        int l = 0;
                        while (l < height) {
                            if (this.pics[i][j].getRGB(k, l) % 0x1000000 == Color.white.getRGB()) {
                                this.pics[i][j].setRGB(k, l, 0xFFFFFF);
                            }
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            bi.flush();
        }

        private void flush() {
            int i = 0;
            while (i < this.passel) {
                int j = 0;
                while (j < this.steps) {
                    this.pics[i][j].flush();
                    ++j;
                }
                ++i;
            }
        }
    }
}

