/*
 * Decompiled with CFR 0.152.
 */
package cbge.data;

import cbge.CBError;
import cbge.data.CBMemory;
import cbge.data.CBUpdater;
import cbge.graphics.CBSprite;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Stream;

public class CBStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static transient String root;
    private static CBStream link;
    private transient HashMap<String, VirtualFile> files = new HashMap();
    private HashMap<String, CBStream> folders = new HashMap();
    private transient CBStream parent;
    private transient String name;
    private byte loadState = 0;

    private CBStream(CBStream parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public static void setRoot(String path) {
        root = "".equals(path) ? System.getProperty("user.dir") : path;
        link = new CBStream(null, null);
        CBMemory.registry("cbge.data.CBStream.link", link, new CBUpdater<CBStream>(){

            @Override
            public void update(CBStream newLink) {
                this.update(newLink, "");
                CBSprite.update(false);
            }

            private void update(CBStream folder, String path) {
                switch (folder.loadState) {
                    case 0: {
                        CBStream.abandon(path, true);
                        break;
                    }
                    case 2: {
                        CBStream.load(path, true);
                        break;
                    }
                    case 1: {
                        CBStream.load(path, false);
                        File[] fileArray = new File(CBStream.combine2(root, path)).listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.isDirectory()) {
                                String name = f.getName();
                                if (folder.folders.containsKey(name)) {
                                    this.update((CBStream)folder.folders.get(name), CBStream.combine1(path, name));
                                } else {
                                    CBStream.abandon(CBStream.combine1(path, name), true);
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                }
            }
        });
    }

    public static void load(String path, boolean subFolders) {
        CBStream folder = link;
        Object[] objectArray = CBStream.structure(path);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = objectArray[n2];
            if (!folder.folders.containsKey(next)) {
                folder.folders.put(next, new CBStream(folder, next));
            }
            folder = folder.folders.get(next);
            ++n2;
        }
        objectArray = new File(CBStream.combine2(root, path)).listFiles();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object f = objectArray[n2];
            String name = ((File)f).getName();
            if (((File)f).isDirectory()) {
                if (subFolders) {
                    CBStream.load(CBStream.combine1(path, name), true);
                }
            } else if (!folder.files.containsKey(name)) {
                folder.files.put(name, new VirtualFile(String.valueOf(CBStream.combine2(root, path)) + "/" + name));
            }
            ++n2;
        }
        folder.loadState = (byte)(subFolders ? 2 : 1);
    }

    public static void abandon(String path, boolean subFolders) {
        CBStream folder = link;
        String[] stringArray = CBStream.structure(path);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (!folder.folders.containsKey(next)) {
                return;
            }
            folder = folder.folders.get(next);
            ++n2;
        }
        folder.files.clear();
        if (subFolders) {
            folder.folders.clear();
        }
        folder.loadState = 0;
        folder.clean(null);
    }

    private void clean(String folder) {
        if (this.loadState == 2) {
            this.loadState = 1;
        }
        if (folder != null) {
            this.folders.remove(folder);
        }
        if (this.parent != null) {
            this.parent.clean(this.files.isEmpty() && this.folders.isEmpty() ? this.name : null);
        }
    }

    public static boolean loaded(String path, boolean subFolders) {
        CBStream folder = link;
        String[] stringArray = CBStream.structure(path);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (!folder.folders.containsKey(next)) {
                return false;
            }
            folder = folder.folders.get(next);
            ++n2;
        }
        return folder.loadState > (subFolders ? (byte)1 : 0);
    }

    public static InputStream get(String path, String name) {
        CBStream folder = link;
        String[] stringArray = CBStream.structure(path);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (!folder.folders.containsKey(next)) {
                folder = null;
                break;
            }
            folder = folder.folders.get(next);
            ++n2;
        }
        if (folder == null || !folder.files.containsKey(name)) {
            try {
                return new BufferedInputStream(new FileInputStream(String.valueOf(CBStream.combine2(root, path)) + "/" + name));
            }
            catch (FileNotFoundException e) {
                CBError.error("cbge.data.CBStream.get(String, String): Datei " + CBStream.combine2(root, path) + "/" + name + " existiert nicht", e);
                return null;
            }
        }
        return folder.files.get(name).get();
    }

    private static String[] structure(String path) {
        return "".equals(path) ? new String[]{} : path.split("/");
    }

    private static String combine1(String a, String b) {
        return String.valueOf(a) + ("".equals(a) ? "" : "/") + b;
    }

    private static String combine2(String a, String b) {
        return String.valueOf(a) + ("".equals(b) ? "" : "/") + b;
    }

    public static String[] fileList(String file, String format) {
        return CBStream.fileList(file, format, true);
    }

    public static String[] fileList(String file, String format, boolean sort) {
        Stream<File> stream = Arrays.stream(new File(file).listFiles()).filter(f -> f.getName().contains(format));
        if (sort) {
            stream = stream.sorted((f1, f2) -> new Date(f2.lastModified()).compareTo(new Date(f1.lastModified())));
        }
        return (String[])stream.map(f -> f.getName().substring(0, f.getName().length() - format.length())).toArray(String[]::new);
    }

    public static void copyFile(String file, String direction) {
        File s = new File(file);
        File t = new File(String.valueOf(direction) + "/" + s.getName());
        try {
            int b;
            t.createNewFile();
            BufferedInputStream i = new BufferedInputStream(new FileInputStream(s));
            BufferedOutputStream o = new BufferedOutputStream(new FileOutputStream(t));
            while ((b = i.read()) != -1) {
                o.write(b);
            }
            i.close();
            o.close();
        }
        catch (IOException e) {
            CBError.error("CBStream.copy(String, String)", e);
        }
    }

    private static class VirtualFile {
        private byte[] fileData;

        private VirtualFile(String path) {
            long length = new File(path).length();
            if (length > Integer.MAX_VALUE) {
                CBError.error("cbge.data.CBStream.VirtualFile(String): File '" + new File(path).getName() + "' ist zu gro\u00df");
            }
            this.fileData = new byte[(int)length];
            try {
                BufferedInputStream reader = new BufferedInputStream(new FileInputStream(path));
                int z = 0;
                while (z < this.fileData.length) {
                    this.fileData[z] = (byte)(reader.read() - 128);
                    ++z;
                }
                reader.close();
            }
            catch (IOException e) {
                CBError.error("cbge.data.CBStream.VirtualFile.new(String): IOException", e);
            }
        }

        private InputStream get() {
            return new InputStream(){
                private int pointer = 0;

                @Override
                public int read() {
                    if (this.pointer >= fileData.length) {
                        return -1;
                    }
                    return fileData[this.pointer++] + 128;
                }
            };
        }
    }
}

