/*
 * Decompiled with CFR 0.152.
 */
package cbge;

import cbge.CBError;
import cbge.event.CBKeyListener;
import cbge.event.CBMouseListener;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import javax.imageio.ImageIO;

public class CBScreen {
    private static int width;
    private static int height;
    private static Frame f;
    private static Graphics2D screen;
    private static BufferStrategy bs;
    private static BufferedImage bi;
    private static HashSet<CBMouseListener> ml;
    private static HashSet<CBKeyListener> kl;
    private static boolean[] isPressed;
    private static boolean mousePressed;
    private static boolean isBuilt;
    private static int mx;
    private static int my;

    static {
        isBuilt = false;
    }

    public static Frame getObserver() {
        return f;
    }

    public static void build() {
        CBScreen.build(true);
    }

    public static void build(boolean fullscreen) {
        CBScreen.build(fullscreen, false);
    }

    public static void build(boolean fullscreen, boolean fullRes) {
        if (isBuilt) {
            CBError.error("cbge.CBScreen.build(int, int): Screen ist schon ge\u00f6ffnet");
        }
        if (fullRes) {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            width = size.width;
            height = size.height;
        } else {
            width = 800;
            height = 600;
        }
        bi = new BufferedImage(width, height, 4);
        screen = bi.createGraphics();
        isPressed = new boolean[256];
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        f = new Frame(gd.getDefaultConfiguration()){

            @Override
            public void update(Graphics g) {
                g.drawImage(bi, 0, 0, this);
            }
        };
        f.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int k = e.getKeyCode();
                if (k >= isPressed.length) {
                    return;
                }
                if (!isPressed[k]) {
                    isPressed[k] = true;
                    for (CBKeyListener l : kl) {
                        l.keyPressed(e);
                        l.keyPressed(k);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int k = e.getKeyCode();
                if (k >= isPressed.length) {
                    return;
                }
                if (isPressed[k]) {
                    isPressed[k] = false;
                    for (CBKeyListener l : kl) {
                        l.keyReleased(e);
                        l.keyReleased(k);
                    }
                }
            }
        });
        f.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (mousePressed) {
                    return;
                }
                mousePressed = true;
                int x = e.getX();
                int y = e.getY();
                for (CBMouseListener l : ml) {
                    l.mousePressed(e);
                    l.mousePressed(x, y);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!mousePressed) {
                    return;
                }
                mousePressed = false;
                int x = e.getX();
                int y = e.getY();
                for (CBMouseListener l : ml) {
                    l.mouseReleased(e);
                    l.mouseReleased(x, y);
                }
            }
        });
        f.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                mx = e.getX();
                my = e.getY();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                mx = e.getX();
                my = e.getY();
            }
        });
        f.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                for (CBMouseListener l : ml) {
                    l.mouseWheel(e.getWheelRotation());
                    l.mouseWheel(e);
                }
            }
        });
        f.setUndecorated(true);
        f.setIgnoreRepaint(true);
        f.setResizable(false);
        if (fullscreen) {
            gd.setFullScreenWindow(f);
            try {
                gd.setDisplayMode(new DisplayMode(width, height, 32, 0));
            }
            catch (Exception e) {
                CBError.error("cbge.CBScreen.build(): Vollbild kann nicht ge\u00f6ffnet werden", e);
            }
        } else {
            f.setSize(width, height);
            f.setLocationRelativeTo(null);
            f.addNotify();
        }
        f.createBufferStrategy(2);
        bs = f.getBufferStrategy();
        ml = new HashSet();
        kl = new HashSet();
        f.setVisible(true);
        isBuilt = true;
    }

    public static void destroy() {
        if (!isBuilt) {
            CBError.error("cbge.CBScreen.destroy(): Screen ist noch nicht ge\u00f6ffnet");
        }
        if (f != null) {
            f.dispose();
        }
        f = null;
        isBuilt = false;
    }

    public static void surpressCursor() {
        if (!CBScreen.isBuilt()) {
            CBError.error("cbge.CBScreen.surpressCursor(): Der Bildschirm muss ge\u00f6ffnet sein, bevor der Cursor unterdr\u00fcckt werden kann");
        }
        f.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(1, 1, 6), new Point(0, 0), "NOCURSOR"));
    }

    public static Graphics2D getGraphics() {
        return screen;
    }

    public static void draw() {
        Graphics g = bs.getDrawGraphics();
        g.drawImage(bi, 0, 0, f);
        if (!bs.contentsLost()) {
            bs.show();
        }
        g.dispose();
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static boolean isPressed(int k) {
        return isPressed[k];
    }

    public static void addKeyListener(CBKeyListener l) {
        kl.add(l);
    }

    public static void removeKeyListener(CBKeyListener l) {
        kl.remove(l);
    }

    public static void addMouseListener(CBMouseListener l) {
        ml.add(l);
    }

    public static void removeMouseListener(CBMouseListener l) {
        ml.remove(l);
    }

    public static int getMouseX() {
        return mx;
    }

    public static int getMouseY() {
        return my;
    }

    public static boolean isMousePressed() {
        return mousePressed;
    }

    public static boolean isBuilt() {
        return isBuilt;
    }

    public static void screenShot(String path) {
        try {
            ImageIO.write((RenderedImage)bi, "PNG", new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + ".png")));
        }
        catch (IOException e) {
            CBError.error("cbge.CBScreen.screenShot(String): IOException", e);
        }
    }
}

