/*
 * Decompiled with CFR 0.152.
 */
import cbge.CBScreen;
import cbge.event.CBKeyAdapter;
import cbge.event.CBMouseAdapter;
import cbge.physics.CBVector;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class Stein
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient boolean fertig;
    private transient boolean weg;
    private int[] pfeile = new int[6];
    private int position = 0;
    private int schutz = 0;
    private boolean weiss;
    private boolean echt = true;

    Stein(boolean weiss, int ... pfeile) {
        this.weiss = weiss;
        System.arraycopy(pfeile, 0, this.pfeile, 0, 6);
    }

    private Stein(boolean weiss, boolean echt, int schutz, int position, int ... pfeile) {
        this.weiss = weiss;
        this.echt = echt;
        this.schutz = schutz;
        this.position = position;
        System.arraycopy(pfeile, 0, this.pfeile, 0, 6);
    }

    void turn(int times) {
        if (times == 0) {
            this.pfeile[1] = this.pfeile[1] + this.pfeile[5];
            this.pfeile[2] = this.pfeile[2] + this.pfeile[4];
            this.pfeile[5] = this.pfeile[1] - this.pfeile[5];
            this.pfeile[4] = this.pfeile[2] - this.pfeile[4];
            this.pfeile[1] = this.pfeile[1] - this.pfeile[5];
            this.pfeile[2] = this.pfeile[2] - this.pfeile[4];
        } else {
            this.position -= times;
            while (this.position < 0) {
                this.position += 6;
            }
            this.position %= 6;
        }
    }

    boolean weiss() {
        return this.weiss;
    }

    boolean echt() {
        return this.echt;
    }

    Stein copy() {
        return new Stein(this.weiss, this.echt, this.schutz, this.position, this.pfeile);
    }

    boolean up() {
        if (this.schutz < 1) {
            ++this.schutz;
            return true;
        }
        return false;
    }

    boolean down() {
        if (this.schutz >= 0) {
            --this.schutz;
            return true;
        }
        return false;
    }

    int kreis() {
        return this.schutz;
    }

    void flip() {
        this.schutz = 0;
        this.weiss = !this.weiss;
        this.echt = false;
    }

    int getPfeil(int i) {
        return this.pfeile[(this.position + i) % 6];
    }

    public String toString() {
        return String.valueOf(this.getPfeil(0)) + " " + this.getPfeil(1) + " " + this.getPfeil(2) + " " + this.getPfeil(3) + " " + this.getPfeil(4) + " " + this.getPfeil(5);
    }

    boolean equals(Stein s) {
        int i = 0;
        while (i < 12) {
            s.turn(i % 6);
            boolean gleich = true;
            int j = 0;
            while (j < 6) {
                if (this.getPfeil(j) != s.getPfeil(j)) {
                    gleich = false;
                    break;
                }
                ++j;
            }
            if (gleich) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void paint(Graphics g, int x, int y, int radius) {
        if (this.schutz != 0) {
            Farbe.stein(g, this.schutz == 1 ? 7 : 8);
            g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        } else if (!this.echt) {
            Farbe.stein(g, 6);
            g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        } else {
            Farbe.stein(g, 9);
            g.fillOval(x - radius + 3, y - radius + 5, radius * 2 - 6, radius * 2 - 6);
        }
        radius -= 3;
        if (this.weiss) {
            Farbe.stein(g, 4);
        } else {
            Farbe.stein(g, 5);
        }
        g.fillOval(x - radius, y - radius, radius * 2, radius * 2);
        int i = 0;
        while (i < 6) {
            int p = this.getPfeil(i);
            if (p != 0) {
                double phi = 1.0471975511965976 * (double)i;
                CBVector richt1 = new CBVector(Math.cos(phi), Math.sin(phi)).scale(radius);
                CBVector richt2 = new CBVector(richt1.get(1), -richt1.get(0)).scale(0.11);
                CBVector pos1 = new CBVector(x, y);
                CBVector pos2 = richt1.add(pos1);
                CBVector pos3 = richt1.scale(0.5).add(pos1);
                CBVector pos4 = pos3.add(richt2);
                CBVector pos5 = pos3.sub(richt2);
                if (p % 10 != 0) {
                    Farbe.stein(g, p % 10);
                    g.fillPolygon(new int[]{pos2.getInt(0), pos4.getInt(0), pos5.getInt(0)}, new int[]{pos2.getInt(1), pos4.getInt(1), pos5.getInt(1)}, 3);
                }
                if (p / 10 != 0) {
                    Farbe.stein(g, p / 10);
                    g.fillPolygon(new int[]{pos1.getInt(0), pos4.getInt(0), pos5.getInt(0)}, new int[]{pos1.getInt(1), pos4.getInt(1), pos5.getInt(1)}, 3);
                }
            }
            ++i;
        }
    }

    boolean bearbeiten() {
        this.fertig = false;
        this.weg = false;
        this.paint(CBScreen.getGraphics(), CBScreen.getWidth() / 2, CBScreen.getHeight() / 2, 100);
        CBScreen.draw();
        CBKeyAdapter kl = new CBKeyAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void keyPressed(int k) {
                if (k == 38) {
                    Stein.this.turn(-1);
                } else if (k == 40) {
                    Stein.this.turn(1);
                } else if (k == 37) {
                    int p = (Stein.this.pfeile[Stein.this.position] / 10 + 1) % 4;
                    ((Stein)Stein.this).pfeile[((Stein)Stein.this).position] = Stein.this.pfeile[Stein.this.position] % 10 + p * 10;
                } else if (k == 39) {
                    int p = (Stein.this.pfeile[Stein.this.position] % 10 + 1) % 4;
                    ((Stein)Stein.this).pfeile[((Stein)Stein.this).position] = Stein.this.pfeile[Stein.this.position] / 10 * 10 + p;
                } else if (k == 8) {
                    Stein.this.weg = true;
                } else if (k == 10) {
                    Stein.this.fertig = true;
                }
                Stein.this.paint(CBScreen.getGraphics(), CBScreen.getWidth() / 2, CBScreen.getHeight() / 2, 100);
                CBScreen.draw();
            }
        };
        CBMouseAdapter ml = new CBMouseAdapter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    int p = (Stein.this.pfeile[Stein.this.position] / 10 + 1) % 4;
                    ((Stein)Stein.this).pfeile[((Stein)Stein.this).position] = Stein.this.pfeile[Stein.this.position] % 10 + p * 10;
                } else if (e.getButton() == 3) {
                    int p = (Stein.this.pfeile[Stein.this.position] % 10 + 1) % 4;
                    ((Stein)Stein.this).pfeile[((Stein)Stein.this).position] = Stein.this.pfeile[Stein.this.position] / 10 * 10 + p;
                } else if (e.getButton() == 2) {
                    Stein.this.fertig = true;
                }
                Stein.this.paint(CBScreen.getGraphics(), CBScreen.getWidth() / 2, CBScreen.getHeight() / 2, 100);
                CBScreen.draw();
            }

            @Override
            public void mouseWheel(int r) {
                Stein.this.turn(r);
                Stein.this.paint(CBScreen.getGraphics(), CBScreen.getWidth() / 2, CBScreen.getHeight() / 2, 100);
                CBScreen.draw();
            }
        };
        CBScreen.addKeyListener(kl);
        CBScreen.addMouseListener(ml);
        while (!this.fertig && !this.weg) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CBScreen.removeMouseListener(ml);
        CBScreen.removeKeyListener(kl);
        if (this.weg) {
            return false;
        }
        int i = 0;
        while (i < 6) {
            if (this.pfeile[i] % 10 == 0) {
                int n = i;
                this.pfeile[n] = this.pfeile[n] / 10;
            } else if (this.pfeile[i] / 10 > this.pfeile[i] % 10) {
                this.pfeile[i] = this.pfeile[i] % 10 * 10 + this.pfeile[i] / 10;
            }
            ++i;
        }
        return true;
    }
}

